//=============================================================================
// JailBreak Xmas ScoreBoard
//=============================================================================
class SnowJBSB extends JailBreakScoreBoard;


// snow vars
var float dx[35];
var float xp[35];
var float yp[35];
var float am[35];
var float stx[35];
var float sty[35];

var bool bInitialized;
var float MSCounter;
var color UnitColor;

event Tick(float delta)
	{
	MSCounter -= Delta;
	Super.Tick(Delta);
	}
// end snow vars



function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;
// snow vars
	local int i;
	local byte Style;
	local color BaseColor;

	if (!bInitialized)
	{
		MSCounter = 0;
		bInitialized = true;
		for (i=0;i<35;i++)
		{
			dx[i] = 0;
			xp[i] = frand() * Canvas.ClipX;
			yp[i] = frand() * Canvas.ClipY;
			am[i] = frand() * 20;
			stx[i] = 0.08 + frand() / 10; // 0.02
			sty[i] = 1.2 +  frand(); // 0.7
		}
	}
// end snow vars

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;



/*


	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);
	ScoreStart = 58.0/768.0 * Canvas.ClipY;
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, ScoreStart);
		Canvas.DrawText(GRI.GameEndedComments, True);
	}
	else
	{
		Canvas.SetPos(0, ScoreStart);
		DrawVictoryConditions(Canvas);
	}


*/


	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
// snow engine
	Style = Canvas.Style;
	Super.DrawHeader(canvas);

	Canvas.Style = Style;		//ERenderStyle.STY_Normal;

	xl = Canvas.CurX;
	yl = Canvas.CurY;

	for (i=0;i<35;i++)
	{
		if (MSCounter<=0)
		{

			yp[i] += sty[i];
			if (yp[i] > Canvas.ClipY)
			{
				xp[i] = Rand(Canvas.clipX);
				yp[i] = -23;
				stx[i] = 0.08 + frand() /10; // 0.02
				sty[i] = 1.2 +  frand(); // 0.7
			}

			dx[i]+= stx[i];
		}

		Canvas.SetPos(xp[i]+am[i]*sin(dx[i]),yp[i]);
		Canvas.Style = 3;
		Canvas.DrawIcon(texture 'Snow',1);
		Canvas.Style = 1;
	}

	if (MSCounter<=0)
		MSCounter = 0.025;

	Canvas.SetPos(xl,yl);
// end snow engine
}


defaultproperties
{
     TeamName(0)="Red Team"
     TeamName(1)="Blue Team"
     OrdersString="Orders:"
     InString="Location:"
     PlayersNotShown="Player[s] not shown."
     TeamColor(0)=(R=255)
     TeamColor(1)=(G=128,B=255)
     AltTeamColor(0)=(R=200)
     AltTeamColor(1)=(G=94,B=187)
}
